# 機能設計書 138-Pod Security Admission

## 概要

本ドキュメントは、Kubernetes における Pod Security Admission (PSA) の機能設計を記述する。Pod Security Standards に基づく Pod のセキュリティプロファイル検証を行う Admission Controller である。

### 本機能の処理概要

**業務上の目的・背景**：Pod Security Policy (PSP) の後継として設計された機能。Namespace レベルで Pod のセキュリティポリシーを enforce（強制）、audit（監査）、warn（警告）の3つのモードで適用する。Pod Security Standards の Privileged、Baseline、Restricted の3つのレベルに基づいてPod仕様を評価する。

**機能の利用シーン**：クラスター管理者が Namespace ごとにセキュリティポリシーレベルを設定し、Pod の作成・更新時にセキュリティプロファイルの準拠を検証する。

**主要な処理内容**：
1. Namespace ラベルからポリシー（enforce/audit/warn の各レベルとバージョン）を読み取り
2. Pod 作成・更新リクエストの PodSpec に対するポリシー評価
3. Pod を含むリソース（Deployment, ReplicaSet 等）の PodSpec 抽出と評価
4. Namespace 作成・更新時のラベル検証と既存 Pod の違反チェック
5. メトリクス記録

**関連システム・外部連携**：kube-apiserver（Admission Webhook として統合）、Namespace ラベル（ポリシー設定）

**権限による制御**：Namespace ラベルの設定権限により、ポリシーレベルを制御する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Namespace ラベル設定および Pod 作成時に自動的に実行 |

## 機能種別

Admission Controller（検証型）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pod-security.kubernetes.io/enforce | string | No | 強制するポリシーレベル | privileged, baseline, restricted |
| pod-security.kubernetes.io/enforce-version | string | No | 強制するバージョン | latest またはメジャー.マイナー |
| pod-security.kubernetes.io/audit | string | No | 監査するポリシーレベル | privileged, baseline, restricted |
| pod-security.kubernetes.io/audit-version | string | No | 監査するバージョン | latest またはメジャー.マイナー |
| pod-security.kubernetes.io/warn | string | No | 警告するポリシーレベル | privileged, baseline, restricted |
| pod-security.kubernetes.io/warn-version | string | No | 警告するバージョン | latest またはメジャー.マイナー |

### 入力データソース

- Namespace ラベル
- PodSecurityConfiguration（API サーバー設定）
- AdmissionReview リクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AdmissionResponse | admissionv1.AdmissionResponse | 許可/拒否の判定結果 |
| Warnings | []string | 警告メッセージ（warn/audit モード時） |
| AuditAnnotations | map[string]string | 監査アノテーション |

### 出力先

- AdmissionReview レスポンス
- 監査ログ
- メトリクス

## 処理フロー

### 処理シーケンス

```
1. AdmissionReview リクエスト受信
   └─ Validate() でリソースタイプに応じた処理を分岐
2. リソース判定
   ├─ namespaces → ValidateNamespace()
   ├─ pods → ValidatePod()
   └─ その他 → ValidatePodController()
3. ポリシー解決
   └─ PolicyToEvaluate() で Namespace ラベルからポリシーを抽出
4. PodSpec 評価
   └─ Evaluator を使用して PodSpec がポリシーに準拠するか評価
5. 結果生成
   ├─ enforce: 違反時に拒否
   ├─ audit: 違反をアノテーションに記録
   └─ warn: 違反を警告として返却
```

### フローチャート

```mermaid
flowchart TD
    A[AdmissionReview] --> B{リソースタイプ?}
    B -->|namespace| C[ValidateNamespace]
    B -->|pod| D[ValidatePod]
    B -->|その他| E[ValidatePodController]
    C --> F[ラベル検証]
    F --> G{enforce 変更?}
    G -->|Yes| H[既存Pod違反チェック]
    G -->|No| I[結果返却]
    H --> I
    D --> J[Namespace ラベルからポリシー解決]
    E --> J
    J --> K[PodSpec 評価]
    K --> L{enforce 違反?}
    L -->|Yes| M[拒否]
    L -->|No| N{audit/warn 違反?}
    N -->|Yes| O[警告/アノテーション付き許可]
    N -->|No| P[許可]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-138-01 | 3モード評価 | enforce（拒否）、audit（記録）、warn（警告）の3モードで独立評価 | 常時 |
| BR-138-02 | 3レベル | Privileged, Baseline, Restricted の3段階のセキュリティレベル | 常時 |
| BR-138-03 | バージョン指定 | ポリシーのバージョンを指定可能（latest またはメジャー.マイナー） | ラベル設定時 |
| BR-138-04 | Pod コントローラー対応 | Deployment, ReplicaSet, StatefulSet, DaemonSet, Job, CronJob, ReplicationController, PodTemplate からPodSpecを抽出して評価 | Pod コントローラー作成・更新時 |
| BR-138-05 | Namespace 更新時の既存Pod検証 | enforce レベルが変更された場合、既存 Pod を最大3000件チェック | Namespace 更新時 |
| BR-138-06 | Namespace Pod チェックタイムアウト | 既存 Pod のチェックは1秒以内に完了させる | Namespace 更新時 |
| BR-138-07 | デフォルトポリシー | Configuration で指定されたデフォルトポリシーが Namespace ラベル未設定時に適用 | ラベル未設定時 |

## データベース操作仕様

本機能にはデータベース操作はない。API サーバーのインメモリ処理として実行される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | enforce ポリシー違反 | Pod の作成/更新を拒否 |
| - | 警告 | warn ポリシー違反 | 警告メッセージを返却（作成は許可） |
| - | 監査記録 | audit ポリシー違反 | アノテーションに記録（作成は許可） |
| 500 | Internal | NamespaceGetter/PodLister 失敗 | エラーレスポンス返却 |

## トランザクション仕様

Admission Controller はステートレスであり、トランザクション管理は不要。

## パフォーマンス要件

- Pod 作成・更新ごとに評価が実行されるため、低レイテンシが要求される
- Namespace 更新時の既存 Pod チェック: 最大3000件、1秒タイムアウト
- defaultNamespaceMaxPodsToCheck: 3000
- defaultNamespacePodCheckTimeout: 1秒

## セキュリティ考慮事項

- Pod Security Standards の3レベル（Privileged, Baseline, Restricted）に基づく評価
- Namespace ラベルの設定権限により、ポリシーレベルの変更を制御
- audit モードにより、ポリシー違反を検出しつつもサービスへの影響を回避可能
- PodSpec の深い検証（ホストネットワーク、特権コンテナ、seccomp 等）

## 備考

- Pod Security Admission は Pod Security Policy (PSP) の後継
- フィーチャーゲート: PodSecurity（GA）
- Namespace 除外設定が可能（kube-system 等のシステム Namespace）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: Admission 構造体とインターフェース

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | admission.go | `staging/src/k8s.io/pod-security-admission/admission/admission.go` | Admission 構造体（53-73行目）: Configuration, Evaluator, Metrics, PodSpecExtractor 等の依存コンポーネント |
| 1-2 | admission.go | 同上 | NamespaceGetter, PodLister インターフェース（75-81行目）: 外部依存の抽象化 |
| 1-3 | admission.go | 同上 | PodSpecExtractor インターフェース（85-92行目）: Pod コントローラーからの PodSpec 抽出 |

#### Step 2: PodSpec 抽出ロジック

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admission.go | 同上 | defaultPodSpecResources（94-104行目）: 対象リソースの定義。9種類のリソースをサポート |
| 2-2 | admission.go | 同上 | DefaultPodSpecExtractor.ExtractPodSpec()（112-135行目）: リソースタイプごとの switch 文で PodSpec を抽出 |

**読解のコツ**: CronJob は入れ子が深い（JobTemplate.Spec.Template）点に注意。

#### Step 3: Validate メインロジック

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | admission.go | 同上 | Validate()（213-224行目）: リソースタイプに基づく3分岐 |
| 3-2 | admission.go | 同上 | ValidateNamespace()（229行目以降）: Namespace ラベルの検証と既存Pod違反チェック |
| 3-3 | admission.go | 同上 | CompleteConfiguration()（153-169行目）: デフォルト設定の補完 |

### プログラム呼び出し階層図

```
Admission.Validate()
    │
    ├─ ValidateNamespace()
    │      ├─ PolicyToEvaluate() [ラベルからポリシー解決]
    │      ├─ Evaluator.EvaluatePod() [各Podの評価]
    │      └─ Metrics.Record() [メトリクス記録]
    │
    ├─ ValidatePod()
    │      ├─ NamespaceGetter.GetNamespace() [Namespace取得]
    │      ├─ PolicyToEvaluate() [ポリシー解決]
    │      ├─ Evaluator.EvaluatePod() [Pod評価]
    │      └─ Metrics.Record()
    │
    └─ ValidatePodController()
           ├─ PodSpecExtractor.HasPodSpec() [対象リソース判定]
           ├─ PodSpecExtractor.ExtractPodSpec() [PodSpec抽出]
           ├─ PolicyToEvaluate()
           ├─ Evaluator.EvaluatePod()
           └─ Metrics.Record()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

AdmissionReview     ──▶ Validate()                ──▶ AdmissionResponse
                         リソースタイプ分岐

Namespace labels    ──▶ PolicyToEvaluate()         ──▶ Policy (enforce/audit/warn)

PodSpec             ──▶ Evaluator.EvaluatePod()    ──▶ EvaluationResult
                         ポリシー準拠チェック

EvaluationResult    ──▶ 結果生成                    ──▶ Allow/Deny + Warnings + AuditAnnotations
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admission.go | `staging/src/k8s.io/pod-security-admission/admission/admission.go` | ソース | Admission Controller 本体 |
| api/ | `staging/src/k8s.io/pod-security-admission/admission/api/` | ソース | API 型定義、ポリシー設定 |
| api/validation/ | `staging/src/k8s.io/pod-security-admission/admission/api/validation/` | ソース | 設定バリデーション |
| policy/ | `staging/src/k8s.io/pod-security-admission/policy/` | ソース | ポリシー評価エンジン |
| metrics/ | `staging/src/k8s.io/pod-security-admission/metrics/` | ソース | メトリクス記録 |
| api/api.go | `staging/src/k8s.io/pod-security-admission/api/` | ソース | API ラベル定義、Policy 構造体 |
